import cv2
import unittest

from openCVImages import averagePixel
from openCVImages import averageTwoImages
from openCVImages import convertToBlackAndWhite
from openCVImages import flipHorizontal
from openCVImages import numberOfPixels
from openCVImages import tintRed


class Assignment2Test(unittest.TestCase):
    def setUp(self):
        self.testImage = cv2.imread("blueSky.jpg", cv2.IMREAD_GRAYSCALE)
        self.testImage2 = cv2.imread("blueSky_2.jpg",
                                        cv2.IMREAD_GRAYSCALE)
        self.testImage3 = cv2.imread("blueSky.jpg") # Color image!

        if self.testImage == None:
            raise IOError("Error, image blueSky.jpg not found.")
        if self.testImage2 == None:
            raise IOError("Error, image blueSky_2.jpg not found.")

    def test_numberOfPixels(self):
        self.assertEqual( type(numberOfPixels(self.testImage)), type(0) ) 
        print "\n\nSUCCESS: numberofPixels returns the correct output type.\n"

    def test_averagePixel(self):
        self.assertEqual(type(averagePixel(self.testImage)), type(0))
        print "\n\nSUCCESS: averagePixel returns the correct output type.\n"
    
    def test_convertToBlackAndWhite(self):
        self.assertEqual(type(convertToBlackAndWhite(self.testImage)),
                         type(self.testImage))
        print "\n\nSUCCESS: convertToBlackAndWhite returns the correct output type.\n"

    def test_flipHorizontal(self):
        self.assertEqual(type(flipHorizontal(self.testImage)),
                         type(self.testImage))
        print "\n\nSUCCESS: flipHorizontal returns the correct output type.\n"

    def test_averageTwoImages(self):
        self.assertEqual(type(averageTwoImages(self.testImage,
                                               self.testImage2)),
                         type(self.testImage))
        print "\n\nSUCCESS: averageTwoImages returns the correct output type.\n"

    def test_averageTwoImages(self):
        self.assertEqual(type(averageTwoImages(self.testImage,
                                               self.testImage2)),
                         type(self.testImage))
        print "\n\nSUCCESS: averageTwoImages returns the correct output type.\n"

    def test_tintRed(self):
        self.assertEqual( type( tintRed(self.testImage3) ), type(self.testImage3) )
        print "\n\nSUCCESS: tintRed returns the correct output type.\n"

if __name__ == '__main__':
	unittest.main()
